/*********************************************************************************
 * This confidential and proprietary software may be used only as authorized 
 *                      by a licensing agreement from                           
 *                           Cortus S.A.
 *
 *             (C) Copyright 2004, 2005, 2006 Cortus S.A.
 *                           ALL RIGHTS RESERVED
 *
 * The entire notice above must be reproduced on all authorized copies
 * and any such reproduction must be pursuant to a licensing agreement 
 * from Cortus S.A. (http://www.cortus.com)
 *
 * Release:  Discretix R3.1.1
 * Filename: vfprintf.c
 *
 *********************************************************************************/

#include "DX_VOS_BaseTypes.h"
#include <stdio.h>
#include <stdarg.h>
#include "vos_op_code.h"
#include "dx_hw_defs.h"

/* Limited base function version for the entire [.*]printf family of functions.

   Format is %[flags][width][.prec][size][type] 
   
   The '#' flag is not supported.

   Note that the behaviour when strange combinations of flags and types are used
   will probably differ from standard implementations.
   (e.g. %+s will precede string value by a '+'sign). 

   All ANSI defined normal usages should produce the same results as required by 
   the ANSI standard.

   Width and precision can be specified as '*'.
   
   The size flags accepted are 'l' and 'h' - both have no effect (long is the
   same length as int, and shorts are promoted to int - so for normal usage this
   is the correct behaviour).
   
   Supported types are 'c', 's', 'd', 'u', 'i', 'x', 'X', 'p' with the usual meanings.
   'p' is equivalent to '08x' ('04x' for the APS16).

   The floating point formats 'e' 'E' 'g' 'G' are not supported.
   The 'n' format is not supported either - but when did you use that one???
*/      
int vfprintf(FILE* f, const char* format, va_list argp)
{
	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_VFPRINTF_OP_CODE, 3,
	   							 /* PARAMETERS: */
								 f, 
								 format,
								 argp);
}

/* Convert unsigned value x to decimal string in buffer.
   Buffer must be at least 11 characters long */
int     fflush(FILE *fp)
{
	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_FFLUSH_OP_CODE, 1,
	   							 /* PARAMETERS: */
								 fp);
}


